 ; Ŀ
 ;   Elsp - elliptical spiral maker.                                       
 ;   Copyright 1999 by Rocket Software                                     
 ;   Onions: are they a metaphor for all knowledge?                        
 ; 
 (DEFUN C:ELSP (/ ppa pax pay revp pointp rad0p rad0-2 rad1p rad1-2 inc
                                          rad0np rad1np 0incr 1incr incrfp ang)
  (setvar "cmdecho" 0)
  (command "undo" "m")
 ; Ŀ
 ;   First get the centre point.                                           
 ; 
  (if (null pa) (setq pa (getvar "viewctr")))
  (setq ppa (getpoint pa "Centre: "))
  (if ppa (setq pa ppa))
  (setq pax (car pa))
  (setq pay (cadr pa))
 ; Ŀ
 ;   Number of rotations.  Initget 6 = positive nonzero only.              
 ; 
  (initget 6)
  (if (/= (type revs) 'INT) (setq revs 5))
  (setq revp (getint (strcat "\nRevolutions <" (itoa revs) ">: ")))
  (if revp (setq revs revp))
 ; Ŀ
 ;   Points per rotation.                                                  
 ; 
  (initget 6)
  (if (/= (type points) 'INT) (setq points 360))
  (setq pointp (getint (strcat "\nPoints per Revolution <"
                                (itoa points) ">: ")))
  (if pointp (setq points pointp))
 ; Ŀ
 ;   The minor axis length.  Initget 6 = positive nonzero only.            
 ; 
  (initget 6)
  (if (/= (type rad0) 'REAL) (setq rad0 75.0))
  (setq rad0p (getdist (strcat "\nInitial Minor axis length <"
                                (rtos rad0 2 2) ">: ")))
  (if rad0p (setq rad0 rad0p))
  (setq rad0-2 (/ rad0 2))
 ; Ŀ
 ;   The major axis length.                                                
 ; 
  (initget 6)
  (if (/= (type rad1) 'REAL) (setq rad1 200.0))
  (setq rad1p (getdist (strcat "\nInitial Major axis length <"
                                (rtos rad1 2 2) ">: ")))
  (if rad1p (setq rad1 rad1p))
  (setq rad1-2 (/ rad1 2))
 ; Ŀ
 ;   See if the axes are to be incremented exponentially or by addition.   
 ; 
  (initget 0 "Exponentially Arithmetically")
  (setq inc (getkword "\nIncrease lengths of axes Exponentially/<Arithmetically>:"))
  (if (or (null inc) (= inc "Arithmetically"))
      (progn
           (setq inc "a")
 ; Ŀ
 ;   Arithmetical:                                                         
 ;   The minor axis length increment.                                      
 ; 
           (if (/= (type rad0in) 'REAL) (setq rad0in 10.0))
           (setq rad0np (getdist (strcat "\nMinor axis increase/rotation <"
                                          (rtos rad0in 2 2) ">: ")))
           (if rad0np (setq rad0in rad0np))
 ; Ŀ
 ;   Arithmetical:                                                         
 ;   The major axis length increment.                                      
 ; 
           (if (/= (type rad1in) 'REAL) (setq rad1in 20.0))
           (setq rad1np (getdist (strcat "\nMajor axis increase/rotation <"
                                          (rtos rad1in 2 2) ">: ")))
           (if rad1np (setq rad1in rad1np))
 ; Ŀ
 ;   Arithmetical:                                                         
 ;   Adjust factors for degrees rather than revolutions.                   
 ; 
           (setq 0incr (/ rad0in points))
           (setq 1incr (/ rad1in points)))
 ; Ŀ
 ;   Exponential:                                                          
 ;   Overall increment factor.                                             
 ; 
      (progn
           (if (/= (type incrf) 'REAL) (setq incrf 1.0025))
           (setq incrfp (getdist (strcat "\nIncrement factor (per point) <"
                                          (rtos incrf 2 5) ">: ")))
           (if incrfp (setq incrf incrfp))))
 ; Ŀ
 ;   Initialize the angle counter, start the Polyline command.             
 ; 
  (setq ang 0)
  (command ".pline")
 ; Ŀ
 ;   Draw the ellipto-spiral.                                              
 ; 
  (while (< ang (* revs pi 2))
         (command (list (+ pax (* rad1-2 (sin ang)))
                        (+ pay (* rad0-2 (cos ang)))))
         (if (= inc "a")
             (progn
                  (setq rad0-2 (+ rad0-2 0incr))
                  (setq rad1-2 (+ rad1-2 1incr)))
             (progn
                  (setq rad0-2 (* rad0-2 incrf))
                  (setq rad1-2 (* rad1-2 incrf))))
         (setq ang (+ ang (/ (* 2 pi) points))))
  (command "")
 (princ))